#ifndef _DEFINED_NetWorkDLS_Standard_Windows_Function_Library_Header
#define _DEFINED_NetWorkDLS_Standard_Windows_Function_Library_Header
////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////
/////////////( External Definitions )/////////////

#define DllImport extern "C" __declspec( dllimport )

//----------( External Open / Save Dialog Definitions )------
#define OFD 1
#define SFD 2

//----------( External Query System Definitions )------
#define MaxQueryLength   1024

//----------( External File Access Definitions )------
#define FAccess  6   // Check for read and write permission
#define FRead    4   // Check for read permission
#define FWrite   2   // Check for write permission
#define FExecute 1   // Execute (Ignored)
#define FExist   0   // Check for existence of file

//----------( External Key Generation Definitions )------
#define MaxKeySeed       1073741824
#define MinKeySeed       1

#define GKNUMBERS        0x1
#define GKUPPER_AZ       0x2
#define GKLOWER_AZ       0x4
#define GKBROADKEY       0x8
#define GKNONREPETITION  0x16

#define MaxKeyLength     10240
#define MinKeyLength     8

////////////////////////////////////////////////////////////////////////////////////////////

//----------( Global Structures )------
struct _QuerySystem{
    char *Query[MaxQueryLength];
    int QuerySize[MaxQueryLength];
    int Used;
    int Free;
};

struct _BufferSystem{
    int BufferSize;
    int TotalSize;
    int Position;
    char *Buffer;
};

//----------( Key Generation Exports )------
DllImport int GenerateSeed(void);
DllImport BOOL GenerateKey(int, int, int, char *);

//----------( Memory Exports )------
DllImport void *Allocate(int);
DllImport int Free(void *);
DllImport int ClearMem(char *, int);
DllImport int StrCat(char *, char *, int, int);
DllImport int MemCopy(char *, char *, int);
DllImport int MemCopyLong(char *, long);
DllImport int MemCopyInt(char *, int);

//----------( Math Exports )------
DllImport int SquareRoot (int);

DllImport int LoByte (unsigned int);
DllImport int HiByte (unsigned int);

DllImport int LongLength(long);
DllImport int IntLength(int);

DllImport int ReverseLong(long);
DllImport int ReverseInt(int);

DllImport DWORD VersionToLong(int, int, int, int);
DllImport BOOL LongToVersion(DWORD, int *, int *, int *, int *);

//----------( Conversion Exports )------
DllImport void LongCharEx (DWORD, char *);
DllImport void FloatCharEx (float, char *);
DllImport void DoubleCharEx (double, char *);
DllImport void IntCharEx (int, char *);

DllImport char * LongChar (DWORD);
DllImport char * FloatChar (float);
DllImport char * DoubleChar (double);
DllImport char * IntChar (int);

DllImport DWORD CharLong (char *);
DllImport float CharFloat (char *);
DllImport double CharDouble (char *);
DllImport int CharInt (char *);

//----------( Windows Exports )------
DllImport void TextBoxWrite(HWND, char *);
DllImport void ErrorMessage(HWND, char *);
DllImport void AlertMessage(HWND, char *, char *);

DllImport int Get_TextLength(HWND);
DllImport DWORD Get_Long(HWND);
DllImport int Get_Int(HWND);
DllImport void Set_Long(HWND, DWORD);
DllImport void Set_Int(HWND, int);
DllImport void Set_Text (HWND, char *);
DllImport int Get_TextEx (HWND, char *, int);
DllImport char *Get_Text (HWND);

DllImport void CenterWindow (HWND );

DllImport LRESULT CALLBACK Set_Color(int, int, int);

DllImport int IsMouseOverHwnd(HWND);

DllImport int OSFileDialog (HWND, char *, char *, char *, char *, char *, DWORD, DWORD);
DllImport int BrowseDirectory(HWND, char *, int , char *);

DllImport HFONT MakeFont(char *, int);
DllImport void SetFont(HWND, HFONT);

//----------( String Exports )------
DllImport char * LCase (char *);
DllImport char * UCase (char *);

DllImport int ReverseString(char *, int);
DllImport int CopyString(char *, char *, int);

DllImport char *StringScan (char *, int, int);
DllImport int StringScanEx(char *, int, int, char *);
DllImport int SearchString(char *, char *);

DllImport int ReplaceStrings (char *, char *, char *, char *);
DllImport int ReplaceCharacter(char *, char *, char, char);

DllImport BOOL CompareNCString(char *, char *);
DllImport BOOL CompareCSString(char *, char *);

DllImport int AppendStrings(char *, char *, int, int, char *);
DllImport int GetFlagedValue(char *, int, int, char *);
DllImport int CompareFlagedString(char *, char *);

DllImport int SimpleCipherString(char *, int);

//----------( System Exports )------
DllImport char * Get_Time (void);
DllImport char * Get_LongDate (void);
DllImport char * Get_ShortDate (void);

DllImport int Get_TimeEx (char *);
DllImport int Get_LongDateEx (char *);
DllImport int  Get_ShortDateEx (char *);

DllImport void Get_LocalDateTime(DWORD *, DWORD *);
DllImport void Get_SystemDateTime(DWORD *, DWORD *);

DllImport BOOL IsDirectory(char *);
DllImport BOOL  FileAccess(char *, short);
DllImport DWORD Get_FileSize(char *);

DllImport DWORD Get_CurrentDirectoryEx (char *);
DllImport DWORD Get_TempDirectoryEx (char *);
DllImport DWORD Get_WindowsDirectoryEx (char *);
DllImport DWORD Get_SystemDirectoryEx (char *);

DllImport char * Get_CurrentDirectory (void);
DllImport char * Get_TempDirectory (void);
DllImport char * Get_WindowsDirectory (void);
DllImport char * Get_SystemDirectory (void);

DllImport BOOL IsWinNT(void);

DllImport BOOL Get_MachineNameEx (char *);
DllImport BOOL Get_UserNameEx (char *);

DllImport char * Get_MachineName (void);
DllImport char * Get_UserName (void);

DllImport void Get_OsVersionEx (char *);
DllImport char * Get_OsVersion (void);

DllImport void SetApplicationPriority(HANDLE, HANDLE, short, short, BOOL, BOOL);

//----------( Registry Exports )------
DllImport int DeleteRegistryValue(HKEY, LPCTSTR, LPCTSTR);

DllImport int CreateRegistryKey(HKEY, LPCTSTR);
DllImport int DeleteRegistryKey(HKEY, LPCTSTR);

DllImport int Set_BinaryRegistryValue(HKEY, LPCTSTR, LPCTSTR, PVOID, DWORD);
DllImport int Get_BinaryRegistryValue(HKEY, LPCTSTR, LPCTSTR, PVOID, DWORD&);

DllImport int Set_DWORDRegistryValue(HKEY, LPCTSTR, LPCTSTR, DWORD);
DllImport int Get_DWORDRegistryValue(HKEY, LPCTSTR, LPCTSTR, DWORD&);

DllImport int Set_StringRegistryValue(HKEY, LPCTSTR, LPCTSTR, LPCTSTR);
DllImport int Get_StringRegistryValue(HKEY, LPCTSTR, LPCTSTR, LPTSTR, DWORD&);

//----------( Query System Exports )------
DllImport BOOL InitilizeQuery(struct _QuerySystem *);
DllImport BOOL FreeQuery(struct _QuerySystem *);
DllImport BOOL InsertQueryItem(struct _QuerySystem *, char *, int, int);
DllImport BOOL AddQueryItem(struct _QuerySystem *, char *, int);
DllImport int ReadQueryItem(struct _QuerySystem *, int, char *);
DllImport int GetQueryItem(struct _QuerySystem *, int, char *);
DllImport BOOL DeleteQueryItem(struct _QuerySystem *, int);

//----------( Buffer System Exports )------
DllImport BOOL InitilizeBufferSystem(struct _BufferSystem *, int);
DllImport BOOL FreeBufferSystem(struct _BufferSystem *);
DllImport BOOL AppendToBuffer(struct _BufferSystem *, char *, int);
DllImport BOOL ReadFromBuffer(struct _BufferSystem *, int, char *);

//----------( DateTime Exports )------
DllImport void LongToDate(DWORD, int *, int *, int *);
DllImport void LongToTime(DWORD, int *, int *, int *);

DllImport DWORD DateToLong(int, int, int);
DllImport DWORD TimeToLong(int, int, int);

//----------( List Box  Exports )------
DllImport int InsertListBoxItem(HWND, char *, int);
DllImport int InsertListBoxItemEx(HWND, char *, int, int);
DllImport int ClearListBox(HWND);
DllImport int DeleteListBoxItem(HWND, int);
DllImport int CountListBoxItems(HWND);
DllImport int SelectMultipleListBoxItem(HWND, int, BOOL);
DllImport int SelectListBoxItem(HWND, int);
DllImport int CurrentListBoxItem(HWND);
DllImport char *ListBoxItemText(HWND, int);
DllImport void ListBoxItemTextEx(HWND, int, char *);
DllImport int ListBoxItemLength(HWND, int);
DllImport int HorizontalListBoxExtent(HWND, int);

//----------( NetLogo Control Exports )------
DllImport BOOL NetLogo(HWND);
DllImport BOOL IsNetLogoActive(void);
DllImport void EndNetLogo(void);
DllImport HWND NetLogoHandle(void);

////////////////////////////////////////////////////////////////////////////////////////////
#endif

